/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.passwordprotect.commands;

import de.dustplanet.passwordprotect.PasswordProtect;
import de.dustplanet.passwordprotect.utils.PasswordProtectUtilities;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@SuppressFBWarnings(value={"IMC_IMMATURE_CLASS_NO_TOSTRING"})
public class PasswordProtectPasswordCommand
implements CommandExecutor {
    private final PasswordProtect plugin;
    private final PasswordProtectUtilities utils;

    public PasswordProtectPasswordCommand(PasswordProtect instance) {
        this.plugin = instance;
        this.utils = instance.getUtils();
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        Player player;
        if (sender instanceof Player && !(player = (Player)sender).hasPermission("passwordprotect.getpassword")) {
            String messageLocalization = this.plugin.getLocalization().getString("permission_denied");
            this.utils.message((CommandSender)player, messageLocalization, null);
            return true;
        }
        String cleanServerPassword = this.getPasswordIfPossible(sender);
        if (cleanServerPassword != null && !this.utils.isPasswordSet() && this.plugin.getConfig().getBoolean("cleanPassword", false)) {
            String messageLocalization = this.plugin.getLocalization().getString("config_invalid");
            this.utils.message(sender, messageLocalization, null);
        }
        return true;
    }

    @Nullable
    private String getPasswordIfPossible(CommandSender sender) {
        String cleanServerPassword = this.utils.getCleanPassword();
        if (cleanServerPassword == null && this.utils.isPasswordSet() && !this.plugin.getConfig().getBoolean("cleanPassword", false)) {
            String messageLocalization = this.plugin.getLocalization().getString("only_hashed");
            this.utils.message(sender, messageLocalization, null);
        } else if (cleanServerPassword == null && !this.utils.isPasswordSet()) {
            String messageLocalization = this.plugin.getLocalization().getString("password_not_set");
            this.utils.message(sender, messageLocalization, null);
        } else if (cleanServerPassword != null && this.utils.isPasswordSet()) {
            String messageLocalization = this.plugin.getLocalization().getString("password");
            this.utils.message(sender, messageLocalization, cleanServerPassword);
        } else {
            sender.sendMessage(ChatColor.DARK_RED + "You shouldn't see this message. Please report this issue, including a copy of the config!");
        }
        return cleanServerPassword;
    }
}

